package gov.va.vinci.dart.biz;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class RequestSummary {

	private int requestId;
	private int activityId;
	private int reviewId;
	private String trackingNumber;
	private String activityName;
	private java.util.Date submittedOn;
	private java.sql.Timestamp updatedOn;
	private int type;
	private int totalReviews;
	private int completedReviews;
	private String principalInvestigatorName = "";
	private boolean retrievedPrincipalInvestigatorName = false;
	private long daysElapsed;
	private String requestType;
	private boolean researchRequest = false;
	private boolean operationsRequest = false;
	private boolean preparatoryRequest = false;
	private boolean editable = false;
	private boolean amendable = false;
	
	private List<WorkflowSummary> workflowSummaryList = new ArrayList<WorkflowSummary>();
	

	public int getRequestId() {
		return requestId;
	}

	public void setRequestId(int id) {
		this.requestId = id;
	}

	public int getActivityId() {
		return activityId;
	}

	public void setActivityId(int activityId) {
		this.activityId = activityId;
	}

	public String getActivityName() {
		return activityName;
	}

	public void setActivityName(String activityName) {
		this.activityName = activityName;
	}

	public java.util.Date getSubmittedOn() {
		return submittedOn;
	}

	public void setSubmittedOn(java.util.Date submittedOn) {
		this.submittedOn = submittedOn;
	}

	public java.sql.Timestamp getUpdatedOn() {
		return updatedOn;
	}

	public void setUpdatedOn(java.sql.Timestamp updatedOn) {
		this.updatedOn = updatedOn;
	}

	public int getTotalReviews() {
		return totalReviews;
	}

	public void setTotalReviews(int totalReviews) {
		this.totalReviews = totalReviews;
	}

	public int getCompletedReviews() {
		return completedReviews;
	}

	public void setCompletedReviews(int completedReviews) {
		this.completedReviews = completedReviews;
	}

	public String getTrackingNumber() {
		return trackingNumber;
	}

	public void setTrackingNumber(String trackingNumber) {
		this.trackingNumber = trackingNumber;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public int getReviewId() {
		return reviewId;
	}

	public void setReviewId(int reviewId) {
		this.reviewId = reviewId;
	}
	
	public String getPrincipalInvestigatorName() {
		return principalInvestigatorName;
	}

	public void setPrincipalInvestigatorName(String principalInvestigatorName) {
		this.principalInvestigatorName = principalInvestigatorName;
	}

	public boolean isRetrievedPrincipalInvestigatorName() {
		return retrievedPrincipalInvestigatorName;
	}

	public void setRetrievedPrincipalInvestigatorName(
			boolean retrievedPrincipalInvestigatorName) {
		this.retrievedPrincipalInvestigatorName = retrievedPrincipalInvestigatorName;
	}
	
	public long getDaysElapsed() {
		return daysElapsed;
	}

	public void setDaysElapsed(long daysElapsed) {
		this.daysElapsed = daysElapsed;
	}

	public String getRequestType() {
		return requestType;
	}

	public void setRequestType(String requestType) {
		this.requestType = requestType;
	}

	public boolean isResearchRequest() {
		return researchRequest;
	}

	public void setResearchRequest(boolean researchRequest) {
		this.researchRequest = researchRequest;
	}

	public boolean isPreparatoryRequest() {
        return preparatoryRequest;
    }

    public void setPreparatoryRequest(boolean preparatoryRequest) {
        this.preparatoryRequest = preparatoryRequest;
    }

    public boolean isOperationsRequest() {
		return operationsRequest;
	}

	public void setOperationsRequest(boolean operationsRequest) {
		this.operationsRequest = operationsRequest;
	}

	public boolean isEditable() {
		return editable;
	}

	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	public boolean isAmendable() {
		return amendable;
	}

	public void setAmendable(boolean amendable) {
		this.amendable = amendable;
	}
	
	public List<WorkflowSummary> getWorkflowSummaryList() {
		return workflowSummaryList;
	}
	

	// necessary to use (List<RequestSummary>).contains()
	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof RequestSummary) == false) {
			return false;
		}
		
		RequestSummary rs2 = (RequestSummary)obj;
		return rs2.requestId == this.requestId;
	}
	
	// required to build distinct hash sets
	@Override public int hashCode() {
        return this.requestId;
    }

	
	/** Get a comparator for sorting a list of RequestSummary objects by trackingNumber ascending.
	 * 
	 * @return
	 */
	public static Comparator<RequestSummary> getTrackingNumberComparator() {
		return new Comparator<RequestSummary>() {

			@Override
			public int compare(RequestSummary o1, RequestSummary o2) {
				if (o1 == null && o2 == null) {
					return 0;
				}
				
				if (o1.trackingNumber == null) {
					if (o2.trackingNumber == null) {
						return 0;
					}
					else {
						return -1;
					}
				}
				else {
					if (o2.trackingNumber == null) {
						return 1;
					}
				}
				
				return o1.trackingNumber.trim().compareTo( o2.trackingNumber.trim() );
			}
		};
	}
	
	/** Get a comparator for sorting a list of RequestSummary objects by trackingNumber, descending.
	 * 
	 * @return
	 */
	public static Comparator<RequestSummary> getDescTrackingNumberComparator() {
		return new Comparator<RequestSummary>() {

			@Override
			public int compare(RequestSummary o1, RequestSummary o2) {
				if (o1 == null && o2 == null) {
					return 0;
				}
				
				if (o1.trackingNumber == null) {
					if (o2.trackingNumber == null) {
						return 0;
					}
					else {
						return 1;	//descending sort
					}
				}
				else {
					if (o2.trackingNumber == null) {
						return -1;	//descending sort
					}
				}
				
				return o2.trackingNumber.trim().compareTo( o1.trackingNumber.trim() );	//descending sort
			}
		};
	}
	
}
